# Beating Cancer

Some of you might remember that during my chemo I had a pair of drumsticks in my bag. I've been playing drums for most of my life and have steeped myself learning about the drums and the various drummers that play professionally. I have a list of drummers that have influenced me ([https://decafbad.net/music/drums](https://decafbad.net/music/drums)). There are two drummers on that list that I'd like to highlight: Neil Peart and Bill Rieflin.

Neal Peart has been a major influence for me since I was in high school. His drumming shook proto-me into not only wanting to be a better drummer but also a better person. We lost Neil to glioblastoma on January 7th, 2020. Neil was a thoughtful and considerate drummer and ultimately it was brain cancer that took him from us. Life can serve us cruel ironies.

I considered carrying around a pair of Neil's sticks but decided against it. Neil dealt with his cancer in a private way. He didn't want to tell anyone outside of immediate friends and family about his cancer. The other members of Rush, Alex Lifeson and Geddy Lee, had to lie about Neil's condition until Neil passed away. They literally gave folks minutes to let the news sink in before the rest of the world knew.

I prefer to be the opposite about my cancer. I'd rather folks know what's going on. That's partly why I've been blogging about it and have been very open in answering questions about it.

Another drummer you might not know is Bill Reiflin. He's been the drummer in countless bands that you may or may not have heard of (Ministry, KMFDM, RevCo, Pigface, Lard, REM, Robyn Hitchcock, King Crimson, Swans, Lead into Gold, and more). Bill had colon cancer (stage 4) and kept touring with King Crimson. He didn't sky away from discussing his disease. In the documentary "In the Court of the Crimson King" he talked openly about the challenges he faced while being on tour with cancer. If you're not familiar with King Crimson think of a gig where every musician is at the top of their game playing intensely complex music with other musicians under the watchful eye of a perfectionist. That's not an easy gig by any stretch. But yet Bill showed up, first as one of the Three Headed Drummer configuration near the front of the stage, and then later as a keyboardist.

Bill is at the center in this video: [https://www.youtube.com/watch?v=N1JapuD0ikk](https://www.youtube.com/watch?v=N1JapuD0ikk)

And if you search for "Ministry In Case You Didn't Feel Like Showing Up" he's the drummer on the right. Note that this show might be a little intense for some folks, both in imagery and language.

Unfortunately Bill also passed away in 2020. He made it 8 years into his diagnosis. He buried his wife one year prior after losing her to cancer.

I'd read that when someone completes chemotherapy that they get to ring a bell. Being a percussionist I'm not one to just go "ding" on a bell. Nope, I'd rather rock that bell and give it a bell work-out. So I thought of which drummer I'd memorialize while ringing that bell. 

Did I want to honor my hero, Neil Peart who disappeared from public life to maintain his privacy, or did I want to honor Bill Rieflin who was very public about his diagnosis and how he lived with the disease that mirrored my own?

Sorry, Neil but for once I think Bill's approach was the correct one.

So I looked up what sticks Bill Rieflin played. One equipment listing showed his sticks as being Regal Tip 8As. This proved to be a problem. Regal Tip disappeared for about four years while they retooled their equipment. There were also some non-public squabbling rumors among the Calato family members. The inventory of Regal Tip sticks dried up and became unobtanium. I couldn't find any Regal Tip sticks at all.

So I bought some Vater 8A sticks and carted those around to chemo as a memorial to Bill and in the hopes that I might somehow beat the odds in my own diagnosis.

I kept looking for the Regal Tip sticks though and in late 2023 Regal Tip started making sticks again. And because my life is comedy I managed to find an article about the triple-headed drummer line-up of King Crimson which showed that Bill was playing Regal Tip 5B E sticks, not the 8A sticks that some other site showed.

Whoops.

Which goes to show: don't trust everything you read on the Internet.

I managed to finally get some 5B maple sticks from Regal Tip (along with some 8A sticks). The moment I played them I fell in love. These sticks feel amazing to me. They're also a little bit cheaper than the Shira Kashi Oak PW747W Signature Neil Peart sticks at $21 a pair.

(And yes, I figure this is way more than you probably cared to know about drum sticks. There's a point to all of this, I promise.)

I never got to ring that bell to signal that my chemotherapy was over. That's quite alright. I'm a big boy and I understand that not every cancer journey can end with triumph. I am just glad that I'm still on my journey with cancer. And I'm grateful for sharing this journey with you all. You've all been an integral part of my journey and I appreciate you all.

I decided to tell you all about the drum sticks I've been carting around in my bag not so you'll cart around your own pair of drum sticks. Drum sticks are anywhere from 14" to 17" and can be pretty ungainly. But Regal Tip does sell drum stick keyrings that are a little more portable.

If this story moved you in any way please take one of these drumstick keyrings. I didn't get a bunch of them because too much of anything can become a logistics problem and unnecessary clutter, but I'm willing to get more if these run out. Please let me know at [craig@decafbad.net](mailto:craig@decafbad.net) and I'll get more.

As for what beat I would have played on the bell there's a certain riff that Neil played that went a little something like this:

> Ting ta Ting Ting | Ting ta Ting Ting | Ting Ting ta ta

That's Morse Code for Y Y Z (pronounced Zed if you're Canadian). That is the airport station code for Toronto. Whenever Rush saw that on their luggage tags it meant they were near the end of the tour and could go home and decompress from the rigors of the tour. It's also the riff to one of Rush's most famous instrumentals. I've had the pleasure of playing this song with several folks over the years and it never ceases to bring a smile to everyone's face.

Thank you for being a part of my cancer journey. May we all continue the journey for as long as we can with the friends we meet along the way.
