# Cancer Buddy

Hi there. My name is Craig Maloney. I'll be your cancer buddy if you'll have me. I'm someone who is going through what you're going through right now. I was diagnosed with Stage 4 Rectal Cancer back in January, 2022 and I've been doing chemotherapy ever since. It can seem overwhelming and isolating. I'm here to help you navigate these uncertain waters and give you an idea of what I experienced when I was sitting in the chair, just like you.

The main thing to remember is that you're not alone. You have a great staff here at Cancer Care Associates ready to guide you through this experience. They helped patients like myself relax into this discomfort. I trust them completely each time I'm in the chair and I hope you can extend them that same trust. Seriously, they're great folks.

## I haven't had time to prepare

The first time I was in chemo I literally had no time to prepare. I was told by Dr. Jaiyesimi that I was going in for chemo the next day so I didn't have time to think about creams and other things to try to deaden the pain. I didn't know what to expect and I was scared.

Here's the secret: you're not the first person to have chemo. The nurses here will help guide you through the process. I had the fortune to have a kind nurse help calm me down and explain what was going on. If you have questions please ask them. I'm guessing you haven't done chemo either. We all experience this the first time. Eventually you'll settle into a routine. It might seem difficult to think of this as a routine but trust me, a stranger, that you can get there. You've got this.

## Clothing

I'm a guy so my uniform tends to be T-shirts and jeans. The nurses will work around whatever kinds of clothing you might have but for me I try to keep it simple. One thing I learned is that it's best for me if folks run the tubes under my shirt. When I get my port accessed I lift my shirt to allow the nurse to access the port. This might not work for some, so they can also access it from the neck of the shirt. Reason I chose this is because it keeps the tubes out of the way and keeps the tubes protected by the shirt. It also made using the pump a lot simpler because I could route the tubing over my chest to the pump and then have the whole thing covered by my shirt.

If this seems confusing feel free to talk with the nurse abut the best options. Once again, they're there to help make your experience as comfortable as possible.

## The freezing spray

Some folks prefer to use the cream but if you were like me you didn't have time to apply the numbing cream. The nurses will offer you the freezing spray. Unless you're allergic to cold (and if you're new to Michigan I'm so, so sorry) you should be fine. Here's a little secret: I've never used the cream. The nurses here are so good that the "little poke" you get accessing your port won't be that big of a deal. I've even tried it without the freezing spray just to see if there was a difference.

Your experience may be different and you may prefer to use the cream. No judgment here if you do, but as someone on team spray I'd say that's more than enough to help alleviate the anxiety around getting the "little poke".

## Bespoke cocktails

Every treatment here is different. All of the chemo bags are mixed in the back area specifically for each patient. There's no off-the-shelf treatment. That said, if you get a lot of chemo they will add in the anti-nausea drugs to help you cope with the drugs they're giving you. These are mostly to help with anxiety and the feedback loops that we generate when we feel nausea.

The drugs you're likely to receive are designed to slow your metabolism down. Since cancer cells are busily multiplying they need lots of energy in order to do their work. Slowing your metabolism starves those cells of their needed energy. No energy = no multiplying = cell death. Unfortunately the drugs we have at present are kind of blunt instruments. They're getting better but they aren't as targeted as doctors would like. So your entire system gets slowed down and disrupted in order to target the cancer cells. Over time we may get more targeted therapies but for now it's best we have.

This is of course a gross oversimplification. I'm just a guy writing things into a note, not your doctor. If you have questions on how things are working and doing their business please ask the nurses or your doctor. Fun fact: folks in the medical profession like to talk about their work.

## The airport

I've likened being in the chair to being at the airport for a long layover. Much like the airport you'll be sitting around either conversing with folks, working on something, or napping. Unlike the airport the nurses will do their best to make you feel comfortable. There's beverages and snacks available. I haven't personally taken advantage of this but that's my own failing. Chemo is hard enough, and the nurses want you to be as comfortable as possible. There's blankets if you're cold and books in the back if you want something to read. I tend to bring a laptop with me because I'm wired that way, but you can play with this to figure out what works best for you.

Occasionally there are volunteer doggos and puppers that come by if you want to give doggos and puppers scritches. That's usually late morning. Sadly I'm allergic to dogs so I haven't been able to give them their proper scritches but if I weren't you'd best believe they'd be getting the scritches.

## The bathroom

Since you're being pumped with a bunch of fluids at some point you'll need to use the restroom. The pumps you're connected to have batteries in them so you can unplug them. That's the easy part. Putting the cables up so you don't trip on or roll over them can also be tricky. If you can just drape the cords for the pumps over the pumps themselves. That'll keep things simple.

The hard part is navigating over to the bathroom. Here's my trick. I'm right handed so I use my right hand to guide the pole with the equipment on it. I make sure that the tubes hooked to me aren't on the floor as much as possible and keep them in line with my right arm. Since my port is on my right-hand side that means that ideally there's a line between my port and the dangling bits of tube that hook up to the pumps. I then gently pull on the pole and make sure there are no tubes going underneath the wheels. Once I am sure that the pole and I aren't going to roll over the tubing I then position the pole so it's next to me (on my right side). I then push the pole so it's slightly ahead of me so I can give it good leverage. Once I'm sure nothing is caught on anything (chair, stool, etc.) I then navigate to the bathrooms.

Oh, and always remember where you parked. Each chemo chair has a number in front of it on the ceiling. Make a note of which number was yours so you can navigate back to it when you're done.

There are two bathrooms near the center. They're both unisex bathrooms so either should work. Just make sure that it isn't occupied. Ideally the unoccupied bathroom door will be slightly ajar but if not I gently try the handle by pushing down. If it's locked then it won't budge and you should try the other one.

Now, here's the tricky part: there is a small lip in front of the bathroom proper. If you try to push the chemo pole into the bathroom it won't work. There's too much of a lip for you to power that pole over. You'll need to gently put your foot under one of the legs of the chemo pole just behind the caster and give it a slight lift. You may need to repeat this for one other caster but once you have then you'll be able to achieve enough momentum to get things situated.

The other tricky part is positioning the pole so you don't wrap yourself and the tubing around it. You may need to play with this some but for me I keep that idea of a straight line as much as possible and use that to help me pivot around in order to do my business. The one thing to keep in mind is that if you feel like you're wrapping yourself or the pole in the tubing then you should turn the other way and approach it from that direction.

The same strategy applies for getting out of the bathroom with the pole. Make sure to open the door slowly and get your bearings. Once you've got two casters over the ledge you should be good to go.

Make sure to leave the bathroom door slightly ajar. It helps visually differentiate whether a bathroom is occupied or not.

Once you're back in the chair take stock of where the tubing is and ensure that it's toward the front of the pole. Position the pole back in its place and turn around if you find yourself getting wrapped in the tubing.

If you get stuck or get wrapped around the nurses will be happy to help you. Remember, they're there to help you be comfortable.

This sounds way more complex than it is. With practice this will become second-nature. Just be aware of where the tubing is and be aware of your surroundings and you'll be fine.

## Homework

Since I have Stage 4 Rectal Cancer I was sent home with a pump. The pump can contain FOLFOX or FOLFIRI, which is an abbreviation for the various drugs that are in there. There may be other drugs that will require a pump. In my case the pump was attached to me for 46 hours after my chemo treatment. This was a bit of a surprise to me the first time I experienced it. The pump is essentially a device that hooks up to the apparatus that delivers your chemo to your port. There is what I call the "parachute", which is a piece of sticky vinyl that covers your port to ensure that it doesn't detach while you have the port. You might think this is overkill, but as someone who has forgotten the pump and felt a little tug when I realized my error you will come to realize its wisdom. The pump fits inside of a pouch that's similar to a fanny pack. Each patient receives their own fanny pack so once you adjust it you won't have to adjust it afterward unless you want to.

At home I just wore the fanny pack until it was time for bed. When I went to bed I would put up a TV table and extend the tubing so that I could sleep comfortably (I tend to roll so this worked well for me). If I could I would just sleep with the fanny pack attached to me (and sometimes when I napped I'd do just that).

You will run into instances where the pump will drop. Unfortunately we live in an imperfect world so things happen. As long as the device is still depositing fluid you should be OK if this happens. Lord knows I did it multiple times. (Shh, don't tell the nurses.) Seriously, though, if you think you've damaged the pump call the nurses to double check.

## Getting cleaned up with a pump

Confession time: I tried to shower with the pump and found the whole thing unpleasant. You need to ensure that the "parachute" doesn't get wet, which can be a pain. Again, I'm a guy who works from home so I decided the best approach was to forego a shower until I had the pump removed. You can still do "bits and pits" where you wash off the parts that get sweaty and disgusting but a full-on shower was not happening for me until the pump was removed.

## You're not alone in this

Everyone at Cancer Care Associates; the patients, the staff, the nurses, and the doctors, wants you to get better and have the best quality of life you can have. You're not alone in this. Some of us have been through the same thing you are experiencing. Some of us are still going through that. Every journey with cancer is different but we all have the same goal: to push back cancer and live the best lives we can. It may not be easy and it definitely can be frustrating but we're all in this together.

I wish you every success with your treatment. If you'd like to reach out to talk I'm happy to read your email: [craig@decafbad.net](mailto:craig@decafbad.net). I also blog about my journey at [https://decafbad.net/tag/cancer/](https://decafbad.net/tag/cancer/).

Good luck! You've got this!

(version 1.0)

Text released into the public domain. Feel free to use this however you wish.
